#!/bin/bash
# 功能：解压audit.zip并安装rpm包，重启相关服务
# 要求：以root用户执行（安装rpm和操作systemctl需要root权限）

# 设置脚本遇到错误立即退出
set -e

# 定义颜色输出（可选，用于友好提示）
RED='\033[0;31m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
NC='\033[0m' # 重置颜色

# 第一步：检查是否为root用户
if [ "$(id -u)" -ne 0 ]; then
    echo -e "${RED}错误：此脚本需要以root用户执行！${NC}" >&2
    exit 1
fi

# 第二步：检查audit.zip是否存在
if [ ! -f "./audit.zip" ]; then
    echo -e "${RED}错误：当前目录下未找到audit.zip文件！${NC}" >&2
    exit 1
fi

# 第三步：解压audit.zip
echo -e "${YELLOW}正在解压audit.zip文件...${NC}"
unzip -q audit.zip
if [ $? -eq 0 ]; then
    echo -e "${GREEN}解压audit.zip成功！${NC}"
else
    echo -e "${RED}解压audit.zip失败！${NC}" >&2
    exit 1
fi

# 第四步：检查audit目录是否存在并进入
if [ ! -d "./audit" ]; then
    echo -e "${RED}错误：解压后未找到audit目录！${NC}" >&2
    exit 1
fi
echo -e "${YELLOW}进入audit目录...${NC}"
cd audit

# 第五步：安装所有rpm包
echo -e "${YELLOW}正在安装目录内的所有rpm包...${NC}"
rpm -Uvh *.rpm
if [ $? -eq 0 ]; then
    echo -e "${GREEN}RPM包安装成功！${NC}"
else
    echo -e "${RED}RPM包安装失败！${NC}" >&2
    exit 1
fi

# 第六步：重载systemd守护进程
echo -e "${YELLOW}重载systemd守护进程...${NC}"
systemctl daemon-reload
echo -e "${GREEN}systemd守护进程重载完成！${NC}"

# 第七步：重启lightdm服务
echo -e "${YELLOW}重启lightdm服务...${NC}"
systemctl restart lightdm
echo -e "${GREEN}lightdm服务重启完成！${NC}"

# 第八步：重启auditd服务
echo -e "${YELLOW}重启auditd服务...${NC}"
systemctl restart auditd
echo -e "${GREEN}auditd服务重启完成！${NC}"

# 最终提示
echo -e "\n${GREEN}所有操作执行完成！${NC}"
exit 0
